#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/ttc/header.h"
#include "levels/bbh/header.h"

extern u8 _ttc_segment_ESegmentRomStart[];
extern u8 _ttc_segment_ESegmentRomEnd[];

const LevelScript level_ttc_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _bbh_segment_7SegmentRomStart, _bbh_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _bbhSegmentRomStart, _bbhSegmentRomEnd),
LOAD_RAW(0x0E, _ttc_segment_ESegmentRomStart, _ttc_segment_ESegmentRomEnd),
LOAD_MIO0(        /*seg*/ 0x0B, _effect_mio0SegmentRomStart, _effect_mio0SegmentRomEnd),
LOAD_MIO0(0xA, _bitfs_skybox_mio0SegmentRomStart, _bitfs_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group5_mio0SegmentRomStart, _group5_mio0SegmentRomEnd),
LOAD_RAW(12, _group5_geoSegmentRomStart, _group5_geoSegmentRomEnd),
LOAD_MIO0(6, _group14_mio0SegmentRomStart, _group14_mio0SegmentRomEnd),
LOAD_RAW(13, _group14_geoSegmentRomStart, _group14_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_BBH_HAUNTED_DOOR,           haunted_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_BBH_STAIRCASE_STEP,         geo_bbh_0005B0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TILTING_FLOOR_PLATFORM, geo_bbh_0005C8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM,      geo_bbh_0005E0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM_PART, geo_bbh_0005F8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MOVING_BOOKSHELF,       geo_bbh_000610),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MESH_ELEVATOR,          geo_bbh_000628),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MERRY_GO_ROUND,         geo_bbh_000640),
LOAD_MODEL_FROM_GEO(MODEL_BBH_WOODEN_TOMB,            geo_bbh_000658),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_GEO(86, 0x05014630),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_6),
JUMP_LINK(script_func_global_15),
JUMP_LINK(local_area_ttc_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_ttc_1_[] = {
AREA(1, Geo_ttc_1_0x17ca550),
TERRAIN(col_ttc_1_0xe02d950),
SET_BACKGROUND_MUSIC(0, 37),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_ttc_1_),
JUMP_LINK(local_warps_ttc_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_ttc_1_[] = {
OBJECT_WITH_ACTS(0, 4105, -560, -431, 0, 270, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(137, 2427, 2310, 75, 0, 0, 0, 0x80000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(122, 5913, 619, -6180, 0, 0, 0, 0x1000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -7752, 1300, -4909, 0, 0, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -706, 3500, -2042, 0, 0, 0, 0x3000000,  bhvStar, 31),
OBJECT_WITH_ACTS(0, 1687, 1184, 4709, 0, 0, 0, 0x4080000,  bhvEyerokBoss, 31),
OBJECT_WITH_ACTS(0, 3275, -2388, 5641, 0, 0, 0, 0x5000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(215, 3593, -961, -1421, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 2008, -1134, 347, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 5040, -1123, 1874, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 5185, -1423, 4049, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 1975, -1463, 4819, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 790, 43, 6025, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 1681, -1173, 5431, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 2273, -800, 5265, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(0, -4740, 1401, 2954, 0, 180, 0, 0xf0b0000,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(0, 2575, 1184, 5420, 0, 270, 0, 0xf0c0000,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(180, 2273, 1484, 4826, 0, 0, 0, 0x4080000,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 1074, 1484, 4819, 0, 0, 0, 0x4080000,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 2273, 1234, 4826, 0, 0, 0, 0x4080000,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 1074, 1234, 4819, 0, 0, 0, 0x4080000,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(0, 3275, -1941, 5641, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 2351, 95, 3613, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 2281, 294, -2346, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 4119, 1308, -5715, 0, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 508, 450, -6400, 0, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -7893, -132, -2956, 0, 90, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -940, 3318, 855, 0, 119, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(137, 1352, -200, -535, 0, 0, 0, 0x60000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 403, 1600, -1206, 0, 0, 0, 0x30000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(140, -2127, 701, -2042, 0, 78, 0, 0x60000,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(118, -1932, 409, -3016, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -1839, 281, -3656, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -1775, 281, -4217, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -1698, 31, -5052, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(137, -5336, -1583, -2579, 0, 0, 0, 0x20000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, -6204, -1106, -398, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(212, -4734, 3751, 4441, 0, 0, 0, 0x70000,  bhv1Up, 31),
OBJECT_WITH_ACTS(188, -598, -19, 2186, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 1682, -2114, 5236, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(0, 1473, 1614, 719, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(212, 3205, -938, 1853, 0, 0, 0, 0x70000,  bhv1Up, 31),
OBJECT_WITH_ACTS(188, 1718, 150, -5049, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -1097, -19, -6317, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -5087, -182, -467, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -6819, -182, -2668, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(0, -4493, -82, -1455, 0, 90, 0, 0x0,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(0, -5976, -82, 491, 0, 90, 0, 0x0,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(116, -6408, 770, 1248, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, -6413, 1071, 1840, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, -5809, 1375, 1846, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, -4914, 1375, 1846, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, -7895, -132, -1755, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, -7591, 154, -1755, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, -7292, 458, -1755, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, -7009, 746, -1755, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, -6702, 1051, -1755, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, -6399, 1348, -1755, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, -6102, 1653, -1755, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(116, -5808, 1956, -1755, 0, 0, 0, 0x0,  bhvYellowCoin, 31),
OBJECT_WITH_ACTS(180, -4893, 2556, -1450, 0, 0, 0, 0x4080000,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, -1160, 3313, 503, 0, 0, 0, 0x4080000,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 2649, -370, -1344, 0, 0, 0, 0x4080000,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 74, 881, -53, 0, 0, 0, 0x4080000,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 2121, -381, 2724, 0, 0, 0, 0x4080000,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, -6255, 465, 501, 0, 0, 0, 0x4080000,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(0, -3687, 3711, 157, 0, 47, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 100, 868, 602, 0, 182, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(137, -1102, 281, 878, 0, 339, 0, 0x60000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 1090, -7, 5584, 0, 180, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -6, 4, 58, 0, 0, 20, 8,  RM_Scroll_Texture, 31),
RETURN()
};

const LevelScript local_warps_ttc_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(11, 14, 1, 12, 0),
WARP_NODE(12, 14, 1, 11, 0),
WARP_NODE(240, 6, 3, 44, 0),
WARP_NODE(241, 6, 3, 54, 0),
RETURN()
};
